"use strict";var dcLib_DEVELOP=0;var dcLib_LogList=new Set;var dcLib_LogButton={};var dcLib_LocalTooltip={delay:400};var dcLib_LocalTooltipAlias=[];var dcLib_LocalTooltipSelector=undefined;var dcLib_LocalTooltipDiabled={};var dcLib_activeElement=false;function isStrict(){return!this}function isIE(){return navigator.userAgent.indexOf("Trident/7.0")>-1}function isEdgeOrIE(){return navigator.userAgent.indexOf("Edge")>-1}function getClientSettings(){let date=new Date;let cs={time:Math.round(Date.now()/1e3),tz_off:date.getTimezoneOffset(),wd:window.innerWidth,ht:window.innerHeight,light:window.matchMedia("(prefers-color-scheme: light)").matches,dark:window.matchMedia("(prefers-color-scheme: dark)").matches,is_ie:isIE()};return cs}function getElementByIdIfString(e){return typeof e==="string"||e instanceof String?document.getElementById(e):e}function removeElement(elem){elem=getElementByIdIfString(elem);if(elem&&elem.parentElement)elem.parentElement.removeChild(elem)}function removeAllChildren(elem){elem=getElementByIdIfString(elem);if(elem)while(elem.childElementCount)elem.removeChild(elem.firstChild)}function removeFirstChildren(elem,n){elem=getElementByIdIfString(elem);if(elem){let leave=elem.childElementCount-parseInt(n===undefined?1:n);while(elem.childElementCount>leave)elem.removeChild(elem.firstChild)}}function removeLastChildren(elem,n){elem=getElementByIdIfString(elem);if(elem){let leave=elem.childElementCount-parseInt(n===undefined?1:n);while(elem.childElementCount>leave)elem.removeChild(elem.lastChild)}}function removeChildrenUntilId(elem,id){elem=getElementByIdIfString(elem);if(elem){for(let i=0;i<elem.children.length;i++)if(elem.children[i].id===id){removeFirstChildren(elem,i);break}}}function removeChildrenUntilIdInc(elem,id){elem=getElementByIdIfString(elem);if(elem){for(let i=0;i<elem.children.length;i++)if(elem.children[i].id===id)break;while(i<elem.children.length&&elem.children[i].id===id)i++;removeFirstChildren(elem,i)}}function removeChildrenFromId(elem,id){elem=getElementByIdIfString(elem);if(elem){for(let i=0;i<elem.children.length;i++)if(elem.children[i].id===id){removeLastChildren(elem,elem.children.length-i);break}}}function removeChildrenUntilClass(elem,cls){elem=getElementByIdIfString(elem);if(elem){for(let i=0;i<elem.children.length;i++)if(elem.children[i].classList.contains(cls)){removeFirstChildren(elem,i);break}}}function removeChildrenUntilClassInc(elem,id){elem=getElementByIdIfString(elem);if(elem){for(let i=0;i<elem.children.length;i++)if(elem.children[i].classList.contains(cls))break;while(i<elem.children.length&&elem.children[i].classList.contains(cls))i++;removeFirstChildren(elem,i)}}function removeChildrenFromClass(elem,cls){elem=getElementByIdIfString(elem);if(elem){for(let i=0;i<elem.children.length;i++)if(elem.children[i].classList.contains(cls)){removeLastChildren(elem,elem.children.length-i);break}}}function insertBefore(elem,anchor){elem=getElementByIdIfString(elem);anchor=getElementByIdIfString(anchor);if(elem&&anchor&&elem!=anchor){let p=anchor.parentElement;if(p)p.insertBefore(elem,anchor)}}function insertBehind(elem,anchor){elem=getElementByIdIfString(elem);anchor=getElementByIdIfString(anchor);if(elem&&anchor&&elem!=anchor){let p=anchor.parentElement;if(p){anchor=anchor.nextSibling;if(anchor)p.insertBefore(elem,anchor);else p.appendChild(elem)}}}function createElementByDef(tag,def){let e=document.createElement(tag);if(e){if(typeof def==="string"||def instanceof String)e.innerHTML=def;else{for(let j in def){switch(j){case"id":e.id=def[j];break;case"class":e.className=def[j];break;case"text":e.innerHTML=def[j];break}}}}return e}function createDummyInput(){let inp=document.createElement("input");inp.type="text";inp.style.position="fixed";inp.style.left="1em";inp.style.top="1em";let body=document.getElementsByTagName("body");body[0].appendChild(inp);return inp}function setClipboardText(text){let active=document.activeElement;if(dcLib_DEVELOP)console.log("active="+active.value);let inp=createDummyInput();if(inp){inp.value=text;inp.select();document.execCommand("copy");inp.remove();if(active)active.focus()}}function xtrim(str){return str.replace(/\s+/g," ").trim()}function getIdByClass(elem,name){let e=getElementByIdIfString(elem);if(e&&e.classList){if(!name)name="eid-";for(let i=0;i<e.classList.length;i++)if(e.classList[i].substr(0,name.length)==name)return e.classList[i].substr(name.length)}return undefined}function toCut(num,digits){let x=parseFloat("0.5e-"+digits);return(num<0?num+x:num-x).toFixed(digits)}function cloneObjectFlat(obj){if(!obj||typeof obj!=="object")return obj;let newobj=obj.constructor();for(let elem in obj)if(obj.hasOwnProperty(elem))newobj[elem]=obj[elem];return newobj}function execFunctionByName(elem,name){if(name===undefined||name==="")return;let namespaces=name.split(".");let func=namespaces.pop();for(let i=0;i<namespaces.length;i++)elem=elem[namespaces[i]];let args=Array.prototype.slice.call(arguments,2);return elem[func].apply(elem,args)}function openWindow(param){let url,name,feat;if(typeof param=="object"){url=param.url;name=param.name;feat=param.features}else{url=param;name=null;feat=null}console.log("openWindow() "+url+", name="+name+", features="+feat);if(url)window.open(url,name,feat)}function createUniqueInt(){return createUniqueInt.count?++createUniqueInt.count:createUniqueInt.count=1}function createUniqueId(){return"dcLib_UID_"+createUniqueInt()}function getUniqueIdByInt(num){return"dcLib_UID_"+num}function createQueryStringByList(list,strict){let result="";for(let i=0;i<list.length;i++){let e=list[i],value=null;if(e.name){switch(e.tagName){case"TEXTAREA":value=e.value;break;case"INPUT":switch(e.type){case"text":case"hidden":case"password":value=e.value;break;case"radio":case"checkbox":if(e.checked)value=e.value?e.value:"on";break}}if(value!==null)result+="&"+(strict?encodeURIComponent(e.name):e.name)+"="+encodeURIComponent(value)}}return result}function getCurrentWord(str,index){if(index<0||index===undefined)index+=str.length;if(index>str.length||index===undefined)index=str.length;let i,j,res={str:str,index:index};for(i=index;i>0&&str[i-1]!=" "&&str[i-1]!="\t";)i--;for(j=index;j<str.length&&str[j]!=" "&&str[j]!="\t";)j++;res.from=i;res.to=j;res.word=str.substr(i,j-i);res.valid=i<j;return res}function getInputData(e){e=getElementByIdIfString(e);if(!e)return null;let res={value:e.value};if(e.selectionStart!==undefined){res.start=e.selectionStart;res.end=e.selectionEnd}return res}function setInputData(e,data){if(typeof data=="object"&&data.value!=undefined){e=getElementByIdIfString(e);if(e){e.value=data.value;if(data.start!==undefined&&e.setSelectionRange)e.setSelectionRange(data.start,data.end)}}}function getValueOrInner(e){if(e)return e.value!==undefined?e.value:e.innerHTML;return undefined}function setValueOrInner(e,val){if(e){if(e.value!==undefined)e.value=val;else e.innerHTML=val}}function getKeyOfEvent(ev){let key=ev.key?ev.key:ev.code;if(key=="Esc")return"Escape";if(key=="Up")return"ArrowUp";if(key=="Down")return"ArrowDown";if(key=="Left")return"ArrowLeft";if(key=="Right")return"ArrowRight";return key}function onKeyByList(ev,keys,func,arg){let key=getKeyOfEvent(ev);let ok=Array.isArray(keys)?keys.includes(ev.key):key==keys;if(ok&&(!func||func(ev,arg))){ev.stopPropagation();ev.preventDefault();return true}return false}function onKeyEnter(ev,func,arg){let key=getKeyOfEvent(ev);if(key=="Enter"&&(!func||func(ev,arg))){ev.stopPropagation();ev.preventDefault();return true}return false}function onKeyEscape(ev,func,arg){console.log("onKeyEscape()");let key=getKeyOfEvent(ev);if(key=="Escape"&&(!func||func(ev,arg))){ev.stopPropagation();ev.preventDefault();return true}return false}function isNumeric(val){return!isNaN(val)&&isFinite(val)}function getRound(obj,fixed){let res={};if(obj){if(fixed!==undefined){for(let nam in obj)if(isNumeric(obj[nam]))res[nam]=obj[nam].toFixed(fixed)}else{for(let nam in obj)if(isNumeric(obj[nam]))res[nam]=Math.round(obj[nam])}}return res}function addMessageToLog(log,msg){if(log&&msg){if(typeof msg==="object")msg=JSON.stringify(msg,null,1);let ul=log.querySelector("ul");if(ul){let li=document.createElement("li");li.innerHTML=msg;ul.appendChild(li)}else log.innerHTML+=msg+"<br>"}}function addToLog0(log,msg){log=getElementByIdIfString(log);return log?log:getElementByIdIfString("dcLib-global-log")}function addToLog(log,msg){log=getElementByIdIfString(log);if(!log)log=getElementByIdIfString("dcLib-global-log");if(log){if(log.innerHTML==""){dcLib_LogList.add(log.id);log.tabIndex=-1;log.classList.add("logging");let button="<button tabindex=-1 type=button ";log.innerHTML="<b>Logging:</b><ul class='narrow'></ul>"+button+"onclick=\"hideElement('"+log.id+"')\">Hide Log</button> "+button+'onclick="hideAllLogs()">Hide All Logs</button> '+button+"onclick=\"clearLog('"+log.id+"')\">Clear Log</button> "+button+'onclick="clearAllLogs()">Clear All Logs</button> ';if(dcLib_LogButton[log.id]){for(let i=0;i<dcLib_LogButton[log.id].length;i++){let but=dcLib_LogButton[log.id][i];log.innerHTML+=button+'onclick="'+but.js+'">'+but.but+"</button> "}}}if(msg||arguments.length>2){if(!log.dataset.timestamp||parseInt(log.dataset.timestamp)+2e3<Date.now()){let now=new Date;addMessageToLog(log,"&#128336; "+("0"+now.getHours()).slice(-2)+":"+("0"+now.getMinutes()).slice(-2)+":"+("0"+now.getSeconds()).slice(-2)+"."+("00"+now.getMilliseconds()).slice(-3))}for(let i=1;i<arguments.length;i++)addMessageToLog(log,arguments[i]);log.dataset.timestamp=Date.now();log.scrollTop=log.scrollHeight}log.style.display="block"}else if(dcLib_DEVELOP>1){if(typeof msg==="object"){console.log("addToLog:");console.log(msg)}else console.log("addToLog: "+msg)}return log}function addTimestampToLog(log,msg){log=addToLog0(log);if(log){log.dataset.timestamp=0;if(msg)addToLog(log,msg)}return log}function hideAllLogs(log){dcLib_LogList.forEach(hideElement)}function clearLog(log){log=getElementByIdIfString(log);if(log){log.innerHTML="";log.style.display="none"}return log}function clearAllLogs(log){dcLib_LogList.forEach(clearLog)}function setClassTR(tr_list,n_same){if(n_same===undefined)n_same=1;let ns=0;let rem="tr1";let add="tr0";if(typeof tr_list==="string"||tr_list instanceof String)tr_list=document.querySelectorAll(tr_list);for(let i=0;i<tr_list.length;i++){let tr=tr_list[i];if(tr.style.display!="none"){tr.classList.remove(rem);tr.classList.add(add);if(++ns>=n_same){ns=0;let temp=rem;rem=add;add=temp}}}}function dcLibPosition(elem){this.getBoundingPos(elem)}dcLibPosition.prototype.reset=function(){this.mode=false;this.x0=0;this.y0=0;this.wd=0;this.ht=0;this.twd=0;this.tht=0;this.left=0;this.top=0;this.right=0;this.bottom=0;return false};dcLibPosition.prototype.getViewPort=function(){this.reset();this.mode="pos";this.wd=this.twd=window.innerWidth;this.ht=this.tht=window.innerHeight;this.left=this.x0;this.right=this.x0+this.twd;this.top=this.y0;this.bottom=this.y0+this.tht;return true};dcLibPosition.prototype.getScrollPos=function(elem){elem=getElementByIdIfString(elem);if(elem){this.mode="scroll";this.x0=elem.scrollLeft;this.y0=elem.scrollTop;this.wd=elem.clientWidth;this.ht=elem.clientHeight;this.twd=elem.scrollWidth;this.tht=elem.scrollHeight;this.left=0;this.top=0;this.right=0;this.bottom=0;return true}return this.reset()};dcLibPosition.prototype.getBoundingPos=function(elem){elem=getElementByIdIfString(elem);if(elem){let rect=elem.getBoundingClientRect();if(rect){this.mode="pos";this.x0=rect.x;this.y0=rect.y;this.wd=this.twd=rect.width;this.ht=this.tht=rect.height;this.left=rect.left;this.top=rect.top;this.right=rect.right;this.bottom=rect.bottom;return true}}return this.reset()};dcLibPosition.prototype.round=function(){this.mode=round(this.mode);this.x0=round(this.x0);this.y0=round(this.y0);this.wd=round(this.wd);this.ht=round(this.ht);this.twd=round(this.twd);this.tht=round(this.tht);this.left=round(this.left);this.top=round(this.top);this.right=round(this.right);this.bottom=round(this.bottom)};dcLibPosition.prototype.getRound=function(){let res=new dcLibPosition;res.mode=round(this.mode);res.x0=round(this.x0);res.y0=round(this.y0);res.wd=round(this.wd);res.ht=round(this.ht);res.twd=round(this.twd);res.tht=round(this.tht);res.left=round(this.left);res.top=round(this.top);res.right=round(this.right);res.bottom=round(this.bottom);return res};function getViewPort(){let pos=new dcLibPosition;pos.getViewPort();return pos}function getScrollPos(elem){let pos=new dcLibPosition;pos.getScrollPos(elem?elem:document.documentElement);return pos}function getBoundingPos(elem){let pos=new dcLibPosition;pos.getBoundingPos(elem?elem:document.documentElement);return pos}function centerElement(elem,dest,limit){if(!(dest instanceof dcLibPosition))dest=getBoundingPos(dest);let pos=getBoundingPos(elem);if(!dest||dest.mode!=="pos"||!pos||pos.mode!=="pos")return false;let dx=(dest.right+dest.left-pos.right-pos.left)/2;let dy=(dest.bottom+dest.top-pos.bottom-pos.top)/2;return moveElementByXY(elem,dx,dy,limit)}function centerElementH(elem,dest,limit){if(!(dest instanceof dcLibPosition))dest=getBoundingPos(dest);let pos=getBoundingPos(elem);if(!dest||dest.mode!=="pos"||!pos||pos.mode!=="pos")return false;let dx=(dest.right+dest.left-pos.right-pos.left)/2;return moveElementByXY(elem,dx,0,limit)}function centerElementV(elem,dest,limit){if(!(dest instanceof dcLibPosition))dest=getBoundingPos(dest);let pos=getBoundingPos(elem);if(!dest||dest.mode!=="pos"||!pos||pos.mode!=="pos")return false;let dy=(dest.bottom+dest.top-pos.bottom-pos.top)/2;return moveElementByXY(elem,0,dy,limit)}function moveElementInto(elem,dest,limit){if(!(dest instanceof dcLibPosition))dest=getBoundingPos(dest);let pos=getBoundingPos(elem);if(!dest||dest.mode!=="pos"||!pos||pos.mode!=="pos")return false;let dx=movePos(pos.left,pos.right,dest.left,dest.right)-pos.left;let dy=movePos(pos.top,pos.bottom,dest.top,dest.bottom)-pos.top;return moveElementByXY(elem,dx,dy,limit)}function moveElementIntoH(elem,dest,limit){if(!(dest instanceof dcLibPosition))dest=getBoundingPos(dest);let pos=getBoundingPos(elem);if(!dest||dest.mode!=="pos"||!pos||pos.mode!=="pos")return false;let dx=movePos(pos.left,pos.right,dest.left,dest.right)-pos.left;return moveElementByXY(elem,dx,0,limit)}function moveElementIntoV(elem,dest,limit){if(!(dest instanceof dcLibPosition))dest=getBoundingPos(dest);let pos=getBoundingPos(elem);if(!dest||dest.mode!=="pos"||!pos||pos.mode!=="pos")return false;let dy=movePos(pos.top,pos.bottom,dest.top,dest.bottom)-pos.top;return moveElementByXY(elem,0,dy,limit)}function movePos(e1,e2,d1,d2){let es=e2-e1;let ds=d2-d1;if(es<=ds){if(e1<=d1)return d1;if(e2<=d2)return e1;return d2-es}if(e1>=d1)return d1;if(e2>=d2)return e1;return d2-es}function moveElementByXY(elem,x,y,limit){elem=getElementByIdIfString(elem);if(elem){if(limit){let pos=getBoundingPos(elem);x=Math.max(Math.min(x,limit.right-pos.right-.5),limit.left-pos.left+.5);y=Math.max(Math.min(y,limit.bottom-pos.bottom-.5),limit.top-pos.top+.5)}x=Math.round(x);y=Math.round(y);if(x||y){let style=window.getComputedStyle(elem);elem.style.left=x+parseFloat(style.left)+"px";elem.style.top=y+parseFloat(style.top)+"px";elem.style.right="auto";elem.style.bottom="auto";return true}}return false}function moveElementToXY(elem,x,y){elem=getElementByIdIfString(elem);if(elem){let style=window.getComputedStyle(elem);let parent=elem.parentElement;if(parent!=document.body){parent.removeChild(elem);document.body.appendChild(elem)}let pos=getBoundingPos(document.body);x-=pos.x0;y-=pos.y0;elem.style.position="absolute";elem.style.left=Math.round(x)+"px";elem.style.top=Math.round(y)+"px";elem.style.right="auto";elem.style.bottom="auto";return true}return false}function cancelLocalTooltip(){if(dcLib_LocalTooltip.timer){addToLog(dcLib_LocalTooltip.log,"cancelLocalTooltip(), cancel timer");clearTimeout(dcLib_LocalTooltip.timer);delete dcLib_LocalTooltip.timer}if(dcLib_LocalTooltip.div){addToLog(dcLib_LocalTooltip.log,"cancelLocalTooltip(), delete div");document.body.removeChild(dcLib_LocalTooltip.div);delete dcLib_LocalTooltip.div}if(dcLib_LocalTooltip.elem)delete dcLib_LocalTooltip.elem}window.addEventListener("scroll",cancelLocalTooltip);function disableLocalTooltip(name){cancelLocalTooltip();dcLib_LocalTooltipDiabled[name]=true}function enableLocalTooltip(name){cancelLocalTooltip();delete dcLib_LocalTooltipDiabled[name]}function viewLocalTooltip(e){if(e&&e!==dcLib_LocalTooltip.elem){cancelLocalTooltip();if(!Object.keys(dcLib_LocalTooltipDiabled).length){let body=document.body.getBoundingClientRect();let rect=e.getBoundingClientRect();if(dcLib_LocalTooltip.log)addToLog(dcLib_LocalTooltip.log,"viewLocalTooltip: "+e.dataset.tooltip);let div=document.createElement("div");div.classList.add("local-tooltip");div.style.position="fixed";div.style.top=rect.bottom+2+"px";div.style.bottom="auto";div.style.left="3px";div.style.right="auto";let content=dcLib_LocalTooltipAlias[e.dataset.tooltip]||e.dataset.tooltip;if(content.substr(0,2)=="c|"){div.style.textAlign="center";content=content.substr(2)}let div2=document.createElement("div");div2.innerHTML=content;div.appendChild(div2);document.body.appendChild(div);centerElementH(div,e,body);moveElementInto(div,getViewPort());dcLib_LocalTooltip.div=div;dcLib_LocalTooltip.elem=e}}}function triggerLocalTooltip(ev){let e=ev.target;while(e&&!e.dataset.tooltip)e=e.parentElement;if(e&&e!==dcLib_LocalTooltip.elem){if(dcLib_LocalTooltip.delay>0){cancelLocalTooltip();dcLib_LocalTooltip.timer=setTimeout(function(){viewLocalTooltip(e)},dcLib_LocalTooltip.delay)}else viewLocalTooltip(e)}}function registerLocalTooltips(selector,auto_update){cancelLocalTooltip();if(selector===undefined||selector==="")selector="[title],[data-tooltip]";if(auto_update)dcLib_LocalTooltipSelector=selector;let count=0;forEachSelector(selector,function(e,a){if(e.title){if(!e.dataset.tooltip)e.dataset.tooltip=e.title.replace(/\n/g,"<br>");e.title=""}if(e.dataset.tooltip){count++;e.addEventListener("mouseover",triggerLocalTooltip);e.addEventListener("mouseleave",cancelLocalTooltip)}});dcLib_LocalTooltip.log=addToLog("log-tooltip","registerLocalTooltips( "+selector+" ) N="+count);if(dcLib_DEVELOP)console.log("registerLocalTooltips( "+selector+", "+auto_update+" ) N="+count)}function registerDataRate(){let count=0;forEachSelector("[data-rate]",function(e,a){let par=e.dataset.rate.split(",",2);if(par[0]){count++;delete e.dataset.rate;let rate=par[0]+"%";let d1=document.createElement("div");let d2=document.createElement("div");d1.style.width=rate;d2.innerHTML=e.innerHTML;e.innerHTML="";e.classList.add("data-rate");if(par[1])e.classList.add(par[1]);e.appendChild(d1);e.appendChild(d2);if(!e.title)e.title=rate}});if(dcLib_DEVELOP)console.log("registerDataRate() N="+count)}function registerDataRate1(){let count=0;forEachSelector("[data-rate]",function(e,a){let rate=e.dataset.rate;if(rate){count++;delete e.dataset.rate;let d1=document.createElement("div");let d2=document.createElement("div");d1.style.width=rate+"%";d2.innerHTML=e.innerHTML;e.innerHTML="";e.classList.add("data-rate");e.appendChild(d1);e.appendChild(d2);if(!e.title)e.title=rate+"%"}});if(dcLib_DEVELOP)console.log("registerDataRate() N="+count)}function forEachHelper(getfunc,list,func,arg,log){let mySet=new Set;if(Array.isArray(list)){for(let i=0;i<list.length;i++){let l=getfunc(list[i]);for(let j=0;j<l.length;j++)mySet.add(l[j])}}else if(list){let l=getfunc(list);for(let j=0;j<l.length;j++)mySet.add(l[j])}if(log)mySet.forEach(function(x){addToLog(log,"> "+x.id)});mySet.forEach(function(x){func(x,arg)})}function forEachId(list,func,arg){forEachHelper(function(a){return[document.getElementById(a)]},list,func,arg)}function forEachClass(list,func,arg){forEachHelper(function(a){return document.getElementsByClassName(a)},list,func,arg)}function forEachName(list,func,arg){forEachHelper(function(a){return document.getElementsByName(a)},list,func,arg)}function forEachTag(list,func,arg){forEachHelper(function(a){return document.getElementsByTagName(a)},list,func,arg)}function forEachSelector(list,func,arg){forEachHelper(function(a){return document.querySelectorAll(a)},list,func,arg)}function forEachElemSelector(elem,list,func,arg){forEachHelper(function(a){return elem.querySelectorAll(a)},list,func,arg)}function setFocus(id,select,log){let e=getElementByIdIfString(id);if(e){e.focus();if(select&&e.value&&e.value.length&&e.setSelectionRange){e.setSelectionRange(0,e.value.length);addToLog(log,"setFocus("+id+") + select(all)")}else addToLog(log,"setFocus("+id+")")}}function setFocusForce(id,select,log){let e=getElementByIdIfString(id);if(e){setFocus(e,select,log);if(e!=document.active)setTimeout(function(){setFocus(e,select,log)},1)}}function sortByTabindex(e1,e2){let a=e1.tabIndex||1;let b=e2.tabIndex||1;return a<b?-1:a<b}function getFocusableElements(base,active){base=getElementByIdIfString(base);if(!base)base=document;if(!active)active=document.activeElement;let sel='a, button, input[type=text], textarea, [tabindex]:not([tabindex="-1"])';let res={active:null,prev:null,next:null,entry:null};res.list=Array.prototype.filter.call(base.querySelectorAll(sel),function(e){return!e.disabled&&e.style.visibility!="hidden"&&(e.offsetWidth>0||e.offsetHeight>0)||e===active});if(!res.list.length&&base!=document)res.list=[base];if(res.list.length){res.list.sort(sortByTabindex);res.index=res.list.indexOf(active);if(res.index<0)res.entry=res.list[0];else{res.entry=res.active=res.list[res.index];res.prev=res.list[(res.index||res.list.length)-1];let next=res.index+1;res.next=res.list[next==res.list.length?0:next]}}if(dcLib_DEVELOP)console.log("getFocusableElements()",res);return res}function focusNextElement(base,active){let focusable=getFocusableElements(base,active);if(focusable.next){focusable.next.focus();let e=document.activeElement;if(e&&e!==focusable.active)setFocus(e,true)}}function nextElementOnEnter(ev){let key=getKeyOfEvent(ev);if(key=="Enter"){ev.stopPropagation();ev.preventDefault();focusNextElement(ev.target.form,ev.target);return true}return false}function preventSubmitOnEnter(base){if(!base)base=document;forEachElemSelector(base,"input:not([type=submit])",function(e){e.addEventListener("keydown",nextElementOnEnter)})}function checkElement(id){let e=getElementByIdIfString(id);if(e)e.checked=true}function checkSelector(sel){forEachSelector(sel,checkElement)}function uncheckElement(id,except){let e=getElementByIdIfString(id);if(e&&(!except||e!=getElementByIdIfString(except)))e.checked=false}function uncheckSelector(sel,except){forEachSelector(sel,uncheckElement,except)}function isRadioSelected(sel){let e=document.querySelector(sel);return e&&e.checked}function getRadioButtonsByName(name){let radio={first:null,checked:null,active:null,entry:null,n_enabled:0};radio.list=document.querySelectorAll('input[type=radio][name="'+name+'"]');for(let i=0;i<radio.list.length;i++){let e=radio.list[i];if(!e.disabled){radio.n_enabled++;if(radio.first===null)radio.first=i;if(e.checked)radio.checked=i;if(e==document.activeElement)radio.active=i}}if(radio.active!==null)radio.entry=radio.active;else if(radio.checked!==null)radio.entry=radio.checked;else if(radio.first!==null)radio.entry=radio.first;return radio}function setRadioFocus(name,log){let radio=getRadioButtonsByName(name);if(radio.active===null&&radio.entry!==null){radio.list[radio.entry].focus();addToLog(log,"setRadioFocus("+name+") index="+radio.entry)}return radio}function selectRadioByValue(name,value,label_class){let radio=getRadioButtonsByName(name);if(label_class)for(let i=0;i<radio.list.length;i++)removeClassFromLabelFor(radio.list[i].id,label_class);for(let i=0;i<radio.list.length;i++)if(radio.list[i].value==value){radio.list[i].checked=true;addClassToLabelFor(radio.list[i].id,label_class);return true}return false}function enableRadio(name,enable,except_checked){if(enable!==undefined&&!enable)return disableRadio(name,except_checked);let radio=getRadioButtonsByName(name);for(let i=0;i<radio.list.length;i++)radio.list[i].disabled=false}function disableRadio(name,except_checked){let radio=getRadioButtonsByName(name);for(let i=0;i<radio.list.length;i++)if(!except_checked||!radio.list[i].checked)radio.list[i].disabled=true}function removeClassFromLabelFor(id,cls){if(id&&cls)forEachSelector("label[for="+id+"]",function(e){e.classList.remove(cls)})}function addClassToLabelFor(id,cls){if(id&&cls)forEachSelector("label[for="+id+"]",function(e){e.classList.add(cls)})}function dcLibStorage(){}dcLibStorage.prototype.store=function(name,val,overwrite){if(overwrite||this[name]==undefined)this[name]=val;return this};dcLibStorage.prototype.get=function(name,default_val){return this[name]||default_val};dcLibStorage.prototype.create=function(name,default_val){return this[name]||(this[name]=default_val)};function getElementStorage(e){if(e){if(typeof e.dcLib!=="object")e.dcLib=new dcLibStorage;return e.dcLib}return new dcLibStorage}function getElementData(e,name,default_val){return e&&e.dcLib&&e.dcLib.get(name,default_val)||default_val}function createElementData(e,name,default_val){return getElementStorage(e).create(name,default_val)}function storeElementData(e,name,val,overwrite){if(e){if(typeof e.dcLib!=="object")e.dcLib=new dcLibStorage;e.dcLib.store(name,val,overwrite)}}function storeDisplayMode(e,mode,overwrite){if(e){if(!mode)mode=window.getComputedStyle(e,null).getPropertyValue("display");if(mode&&mode!="none")storeElementData(e,"display",mode,overwrite)}}function saveDisplayMode(id){storeDisplayMode(getElementByIdIfString(id))}function displayElement(id,val){let e=getElementByIdIfString(id);if(e)e.style.display=val}function displaySelector(list){for(let sel in list)forEachSelector(sel,function(e,a){e.style.display=a},list[sel])}function showElement(id,val){let e=getElementByIdIfString(id);if(e)e.style.display=val||getElementData(e,"display","block")}function showSelector(show,val){if(val)forEachSelector(show,displayElement,val);else forEachSelector(show,showElement)}function hideElement(id){let e=getElementByIdIfString(id);if(e){if(!e.dcLib||!e.dcLib.display)storeDisplayMode(e);e.style.display="none"}}function hideShowSelector(hide,show,val){forEachSelector(hide,hideElement);if(show)showSelector(show,val)}function clearElement(id){let e=getElementByIdIfString(id);if(e){e.innerHTML="";if(e.checked)e.checked=false;if(e.value&&e.getAttribute("type")=="text")e.value=""}}function clearSelector(sel,check){forEachSelector(sel,clearElement);if(check)forEachSelector(check,checkElement)}function visibleElement(id){let e=getElementByIdIfString(id);if(e)e.style.visibility="visible"}function visibleSelector(sel){forEachSelector(sel,visibleElement)}function invisibleElement(id){let e=getElementByIdIfString(id);if(e)e.style.visibility="hidden"}function invisibleSelector(sel){forEachSelector(sel,invisibleElement)}function hideShowElement(hide,show){let h=getElementByIdIfString(hide);if(h)h.style.display="none";let s=getElementByIdIfString(show);if(s)s.style.display="block"}function toggleElement(id){let e=getElementByIdIfString(id);if(e)e.style.display=e.style.display==="block"?"none":"block"}function toggleElementAndButton(id,id_but,t_show,t_hide,tog_class){let b=getElementByIdIfString(id_but);let e=getElementByIdIfString(id);if(!e.style.display||e.style.display==="none"){showElement(e);b.innerHTML=t_show;if(tog_class)b.className="hide-element"}else{hideElement(e);b.innerHTML=t_hide;if(tog_class)b.className="show-element"}}function disableElement(id){let e=getElementByIdIfString(id);if(e)e.disabled=true}function disableSelector(sel){forEachSelector(sel,disableElement)}function enableElement(id){let e=getElementByIdIfString(id);if(e)e.disabled=false}function enableSelector(sel){forEachSelector(sel,enableElement)}function showElements(){for(let i=0;i<arguments.length;i++)showElement(arguments[i])}function hideElements(){for(let i=0;i<arguments.length;i++)hideElement(arguments[i])}function hideShowElements(){if(arguments.length>0){hideElement(arguments[0]);for(let i=1;i<arguments.length;i++)showElement(arguments[i])}}function toggleElements(){for(let i=0;i<arguments.length;i++)toggleElement(arguments[i])}function toggleElementsByFirst(){if(arguments.length>0){let m1,m2,e=getElementByIdIfString(arguments[0]);if(e.style.display==="block"){m1="none";m2="block"}else{m1="block";m2="none"}e.style.display=m1;for(let i=1;i<arguments.length;i++){id=arguments[i];if(id.substr(0,1)=="-")document.getElementById(id.substr(1)).style.display=m2;else document.getElementById(id).style.display=m1}}}function analyseTabindex(base){base=base?getElementByIdIfString(base):document;let res={base:base,current:null,prev:null,next:null,list:null};if(base){let list=res.base.querySelectorAll("[tabindex]")}return res}function setClassElement(id,cls){let e=getElementByIdIfString(id);if(e){e.className="";if(!Array.isArray(cls))cls=cls.split(" ");for(let i=0;i<cls.length;i++)e.classList.add(cls[i])}}function setClassSelector(sel,cls){forEachSelector(sel,setClassElement,cls)}function addClassElement(id,cls){let e=getElementByIdIfString(id);if(e){if(!Array.isArray(cls))cls=cls.split(" ");for(let i=0;i<cls.length;i++)e.classList.add(cls[i])}}function addClassSelector(sel,cls){forEachSelector(sel,addClassElement,cls)}function removeClassElement(id,cls){let e=getElementByIdIfString(id);if(e){if(!Array.isArray(cls))cls=cls.split(" ");for(let i=0;i<cls.length;i++)e.classList.remove(cls[i])}}function removeClassSelector(sel,cls){forEachSelector(sel,removeClassElement,cls)}function toggleClassElement(id,cls){let e=getElementByIdIfString(id);if(e){if(!Array.isArray(cls))cls=cls.split(" ");for(let i=0;i<cls.length;i++)e.classList.toggle(cls[i])}}function toggleClassSelector(sel,cls){forEachSelector(sel,toggleClassElement,cls)}function addEventOnLoad(func){if(window.addEventListener)window.addEventListener("load",func);else if(window.attachEvent)window.attachEvent("onload",func);else if(document.addEventListener)document.addEventListener("load",func);else if(document.attachEvent)document.attachEvent("onload",func)}function addEventListenerById(elem,event,func){elem=getElementByIdIfString(elem);if(elem)elem.addEventListener(event,func)}function addEventListenerByClass(list,event,func){forEachClass(list,function(e){e.addEventListener(event,func)})}function addEventListenerBySelector(list,event,func){forEachSelector(list,function(e){e.addEventListener(event,func)})}function createCustomEvent(name,bubbles,cancelable,detail){bubbles=Boolean(bubbles);cancelable=Boolean(cancelable);if(!detail)detail={log:"event-log"};else if(!detail.log&&!detail.log)detail.log="event-log";if(dcLib_DEVELOP&&detail.log)addToLog(detail.log,"☎ createCustomEvent("+name+") bubbles="+bubbles+", cancelable="+cancelable);if(isIE()){let event=document.createEvent("Event");event.initEvent(name,bubbles,cancelable);event.detail=detail;return event}let init={bubbles:bubbles,cancelable:cancelable,detail:detail};return new CustomEvent(name,init)}function setupEventActivate(){if(dcLib_activeElement===false){addToLog("event-log","☎ setupEventActivate()");dcLib_activeElement={target:null,frame:null,label_id:null,prev_target:null};document.addEventListener("focus",manageEventActivate,true)}forEachClass("dclib-is-frame",function(e){e.classList.remove("dclib-is-frame");e.addEventListener("dc_findframe",onFindFrame)})}function manageEventActivate(ev){let active=document.activeElement;if(active&&active!=dcLib_activeElement.target){dcLib_activeElement.prev_target=dcLib_activeElement.target;let detail={oldtarget:dcLib_activeElement.target,newtarget:active,oldframe:dcLib_activeElement.frame,newframe:null,highlight_frame:true,prevent:false,focus_on_prevent:dcLib_activeElement.target,event:ev};let cev=createCustomEvent("dc_findframe",true,true,detail);active.dispatchEvent(cev);if(dcLib_activeElement.frame&&dcLib_activeElement.frame!=detail.newframe){cev=createCustomEvent("dc_leaveframe",true,false,detail);dcLib_activeElement.frame.dispatchEvent(cev)}if(!detail.prevent){if(dcLib_activeElement.target){cev=createCustomEvent("dc_leavetarget",true,false,detail);dcLib_activeElement.target.dispatchEvent(cev)}if(!detail.prevent){if(dcLib_activeElement.frame)dcLib_activeElement.frame.classList.remove("dclib-active-frame");if(detail.newframe&&detail.highlight_frame)detail.newframe.classList.add("dclib-active-frame");if(dcLib_activeElement.target&&dcLib_activeElement.target!=document.activeElement){dcLib_activeElement.target.classList.remove("dclib-active-target");document.activeElement.classList.add("dclib-active-target")}cev=createCustomEvent("dc_entertarget",true,false,detail);document.activeElement.dispatchEvent(cev);if(detail.newframe&&detail.newframe!=dcLib_activeElement.frame){cev=createCustomEvent("dc_enterframe",true,false,detail);detail.newframe.dispatchEvent(cev)}dcLib_activeElement.target=document.activeElement;dcLib_activeElement.frame=detail.newframe}}if(detail.prevent){ev.stopPropagation();ev.preventDefault();if(detail.focus_on_prevent)setTimeout(function(){detail.focus_on_prevent.focus()},1)}else{if(dcLib_activeElement.label_id!=document.activeElement.id){if(dcLib_activeElement.label_id){forEachSelector("label[for="+dcLib_activeElement.label_id+"]",function(e){e.classList.remove("dclib-active-label")});dcLib_activeElement.label_id=null}if(document.activeElement.id){dcLib_activeElement.label_id=document.activeElement.id;forEachSelector("label[for="+dcLib_activeElement.label_id+"]",function(e){e.classList.add("dclib-active-label")})}}}}}function preventActivation(ev,focus,log){console.log("☎ preventActivation(), detail="+typeof ev.detail+", have_focus="+!!focus);addToLog(log,"☎ preventActivation(), detail="+typeof ev.detail+", have_focus="+!!focus);if(typeof ev.detail=="object"){ev.detail.prevent=true;if(focus)ev.detail.focus_on_prevent=focus}}const DC_ISACT_FOUND=1;const DC_ISACT_DOC=2;const DC_ISACT_TARGET=4;const DC_ISACT_FRAME=8;function isActivated(e){let stat=0;e=getElementByIdIfString(e);if(e){stat=DC_ISACT_FOUND;if(e==document.activeElement)stat=stat|DC_ISACT_DOC;if(dcLib_activeElement){if(e==dcLib_activeElement.target)stat=stat|DC_ISACT_TARGET;if(e==dcLib_activeElement.frame)stat=stat|DC_ISACT_FRAME}}return stat}function onFindFrame(ev,log){if(log)addToLog(log,"☎ onFindFrame("+ev.currentTarget.id+")");ev.detail.newframe=ev.currentTarget;ev.stopPropagation();ev.preventDefault()}function scrollHashToScreen(dist){if(window.location.hash){let hash=window.location.hash.substr(1);let e=document.getElementById(hash);if(e){let pos=getBoundingPos(e);if(pos.y0>=-5&&pos.y0<dist)window.scrollBy(0,pos.y0-dist)}}}function scrollHashToScreenById(id,add){let e=document.getElementById(id);if(e){let pos=getBoundingPos(e);let dist=pos.bottom;if(add)dist+=add;scrollHashToScreen(dist)}}
